﻿Imports <xmlns='urn:art-org:art'>
Imports <xmlns:a='urn:art-org:artists'>
Imports System.Xml

Module Module1

    Sub Main()
        ' 使用 XML Literal 方法
        ' 构造预定义的文档
        Dim document = CreateDocumentLiteral()
        Console.WriteLine(document)

        ' 将所有节点转储到控制台 
        DumpNode(document)

        ' 使用 XML Literal 方法和导入的 XML 命名空间
        ' 再次构造预定义的文档
        document = CreateDocumentLiteralWithImportedNamespaces()
        Console.WriteLine(document)

        ' 将所有节点转储到控制台 
        DumpNode(document)

        ' 使用类似于 XML DOM 的方法
        ' 再次构造预定义的文档
        document = CreateDocumentVerbose()

        ' 在控制台中显示文档
        Console.WriteLine(document)

        ' 将所有节点转储到控制台 
        DumpNode(document)

        ' 使用起作使用的方法
        ' 再次构造预定义的文档
        document = CreateDocumentConcise()

        ' 在控制台中显示文档
        Console.WriteLine(document)

        ' 将所有节点转储到控制台
        DumpNode(document)

        ' 使用 Elements 属性查找所有名为“artist”的元素
        FindChildren(document)

        ' 使用 Descendants 属性查找所有名为“artist”的元素
        FindDescendants(document)

        ' 使用 Attribute 属性(Property)查找名为“name”的属性(Attribute)
        FindAttribute(document)

        Console.ReadLine()
    End Sub
    ' <?xml version="1.0"?>
    ' <?order alpha ascending?>
    ' <art xmlns='urn:art-org:art'>
    '   <period name='Renaissance' xmlns:a='urn:art-org:artists'>
    '     <a:artist>Leonardo da Vinci</a:artist>
    '     <a:artist>Michelangelo</a:artist>
    '     <a:artist><![CDATA[Donatello]]></a:artist>
    '   </period>
    '   <!-- 在此插入 period -->
    ' </art>
    Function CreateDocumentLiteral() As XDocument
        Return <?xml version="1.0"?>
               <?order alpha ascending?>
               <art xmlns='urn:art-org:art'>
                   <period name='Renaissance' xmlns:a='urn:art-org:artists'>
                       <a:artist>Leonardo da Vinci</a:artist>
                       <a:artist>Michelangelo</a:artist>
                       <a:artist><![CDATA[Donatello]]></a:artist>
                   </period>
                   <!-- insert period here -->
               </art>
    End Function

    ' <?xml version="1.0"?>
    ' <?order alpha ascending?>
    ' <art xmlns='urn:art-org:art'>
    '   <period name='Renaissance' xmlns:a='urn:art-org:artists'>
    '     <a:artist>Leonardo da Vinci</a:artist>
    '     <a:artist>Michelangelo</a:artist>
    '     <a:artist><![CDATA[Donatello]]></a:artist>
    '   </period>
    '   <!-- 在此插入 period -->
    ' </art>
    Function CreateDocumentLiteralWithImportedNamespaces() As XDocument
        Return <?xml version="1.0"?>
               <?order alpha ascending?>
               <art>
                   <period name='Renaissance'>
                       <a:artist>Leonardo da Vinci</a:artist>
                       <a:artist>Michelangelo</a:artist>
                       <a:artist><![CDATA[Donatello]]></a:artist>
                   </period>
                   <!-- insert period here -->
               </art>
    End Function

    Function CreateDocumentVerbose() As XDocument
        Dim nsArt As XNamespace = "urn:art-org:art"
        Dim nsArtists As XNamespace = "urn:art-org:artists"

        ' 创建文档
        Dim document = New XDocument()

        ' 创建 xml 声明，并在
        ' 文档中对其进行设置
        document.Declaration = New XDeclaration("1.0", Nothing, Nothing)

        ' 创建 art 元素，并将其
        ' 添加到文档中 
        Dim art = New XElement(nsArt + "art")
        document.Add(art)

        ' 创建顺序处理指令，并将其
        ' 添加到 art 元素之前 
        Dim pi = New XProcessingInstruction("order", "alpha ascending")
        art.AddBeforeSelf(pi)

        ' 创建 period 元素，并将其
        ' 添加到 art 元素中
        Dim period = New XElement(nsArt + "period")
        art.Add(period)

        ' 向 period 元素中添加 name 属性 
        period.SetAttributeValue("name", "Renaissance")

        ' 创建命名空间声明 xmlns:a，并将其
        ' 添加到 period 元素中 
        Dim nsdecl = New XAttribute(XNamespace.Xmlns + "a", nsArtists)
        period.Add(nsdecl)

        ' 创建 artist 元素和
        ' 基础文本节点
        period.SetElementValue(nsArtists + "artist", "Michelangelo")

        Dim artist = New XElement(nsArtists + "artist", "Leonardo ", "da ", "Vinci")
        period.AddFirst(artist)

        artist = New XElement(nsArtists + "artist")
        period.Add(artist)
        Dim cdata = New XText("Donatello")
        artist.Add(cdata)

        ' 创建注释，
        ' 然后将其添加到 art 元素中
        Dim comment = New XComment("insert period here")
        art.Add(comment)

        Return document
    End Function
    Function CreateDocumentConcise() As XDocument
        Dim nsArt As XNamespace = "urn:art-org:art"
        Dim nsArtists As XNamespace = "urn:art-org:artists"

        ' 一次完成文档创建
        Return New XDocument( _
                    New XDeclaration("1.0", Nothing, Nothing), _
                    New XProcessingInstruction("order", "alpha ascending"), _
                    New XElement(nsArt + "art", _
                        New XElement(nsArt + "period", _
                            New XAttribute("name", "Renaissance"), _
                            New XAttribute(XNamespace.Xmlns + "a", nsArtists), _
                            New XElement(nsArtists + "artist", "Leonardo da Vinci"), _
                            New XElement(nsArtists + "artist", "Michelangelo"), _
                            New XElement(nsArtists + "artist", _
                                New XText("Donatello"))), _
                        New XComment("insert period here")))
    End Function

    Sub DumpNode(ByVal node As XNode)
        Select Case node.NodeType
            Case XmlNodeType.Document
                Dim document = CType(node, XDocument)
                Console.WriteLine("StartDocument")
                Dim declaration = document.Declaration
                If declaration IsNot Nothing Then
                    Console.WriteLine("XmlDeclaration: {0} {1} {2}", declaration.Version, declaration.Encoding, declaration.Standalone)
                End If
                For Each n In document.Nodes()
                    DumpNode(n)
                Next
                Console.WriteLine("EndDocument")
            Case XmlNodeType.Element
                Dim element = CType(node, XElement)
                Console.WriteLine("StartElement: {0}", element.Name)
                If element.HasAttributes Then
                    For Each attribute In element.Attributes()
                        Console.WriteLine("Attribute: {0} = {1}", attribute.Name, attribute.Value)
                    Next
                End If
                If Not element.IsEmpty Then
                    For Each n In element.Nodes()
                        DumpNode(n)
                    Next
                    End If
                Console.WriteLine("EndElement: {0}", element.Name)
            Case XmlNodeType.Text
                Dim text = CType(node, XText)
                Console.WriteLine("Text: {0}", text.Value)
            Case XmlNodeType.ProcessingInstruction
                Dim pi = CType(node, XProcessingInstruction)
                Console.WriteLine("ProcessingInstruction: {0} {1}", pi.Target, pi.Data)
            Case XmlNodeType.Comment
                Dim comment = CType(node, XComment)
                Console.WriteLine("Comment: {0}", comment.Value)
            Case XmlNodeType.DocumentType
                Dim documentType = CType(node, XDocumentType)
                Console.WriteLine("DocumentType: {0} {1} {2} {3}", documentType.Name, documentType.PublicId, documentType.SystemId, documentType.InternalSubset)
        End Select
    End Sub

    Sub FindChildren(ByVal document As XDocument)
        ' 对 XDocument 对象使用 Elements 属性，以检索所有名为“artist”的元素
        Dim results = document.<art>.<period>.<a:artist>
        For Each element In results
            Console.WriteLine("Child 'artist' Element: " & element.Value)
        Next

        ' 对 XElement 对象使用 Elements 属性，以检索所有名为“artist”的元素
        Dim periodElement = document.<art>.<period>(0)
        results = periodElement.<a:artist>
        For Each element In results
            Console.WriteLine("Child 'artist' Element: " & element.Value)
        Next
    End Sub

    Sub FindDescendants(ByVal document As XDocument)
        ' 对 XDocument 对象使用 Descendants 属性，以检索所有名为“artist”的元素
        Dim results = document...<a:artist>
        For Each element In results
            Console.WriteLine("Descendant 'artist' Element: " & element.Value)
        Next

        ' 对 XElement 对象使用 Descendants 属性，以检索所有名为“artist”的元素
        Dim artElement = document.<art>(0)
        results = artElement...<a:artist>
        For Each element In results
            Console.WriteLine("Descendant 'artist' Element: " & element.Value)
        Next
    End Sub

    Sub FindAttribute(ByVal document As XDocument)
        ' 使用 Attribute 属性(Property)和 Elements 属性(Property)检索 XDocument 对象内
        '  名为“period”的元素中第一个名为“name”的属性(Attribute)
        Dim result = document.<art>.<period>.@name
        Console.WriteLine("'name' Attribute: " & result)

        ' 使用 Attribute 属性(Property)和 Descendants 属性(Property)检索 XDocument 对象内
        '  名为“period”的元素中第一个名为“name”的属性(Attribute)
        result = document...<period>.@name
        Console.WriteLine("'name' Attribute: " & result)

        ' 使用 Attribute 属性(Property)和 Descendants 属性(Property)检索 XElement 对象内
        '  名为“period”的元素中第一个名为“name”的属性(Attribute)
        Dim periodElement = document...<period>(0)
        result = periodElement.@name
        Console.WriteLine("'name' Attribute: " & result)
    End Sub
End Module
